/* -LICENSE-START-
 ** Copyright (c) 2010 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 ** 
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 ** 
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
//
//  CDeckLinkPreview.cpp
//  OpenGLOutput
//

#include "CDeckLinkPreview.h"

CDeckLinkPreview::CDeckLinkPreview(HWND parent)
	: deckLinkScreenPreviewHelper(NULL),
	hGLWnd(NULL), hGLDC(NULL), hGLRC(NULL),
	bRender(false)
{
	refCount = 1;
	InitializeCriticalSection(&mutex);

	hGLWnd = parent;
	hGLDC = GetDC(hGLWnd);

	PIXELFORMATDESCRIPTOR pfd;
	int iPixelFormat;
	ZeroMemory( &pfd, sizeof( pfd ) );
    pfd.nSize = sizeof( pfd );
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL;
	pfd.iPixelType = PFD_TYPE_RGBA;
    pfd.cColorBits = 32;
    pfd.cDepthBits = 16;
	pfd.cAlphaBits = 8;
	pfd.iLayerType = PFD_MAIN_PLANE;
	iPixelFormat = ChoosePixelFormat( hGLDC, &pfd );
    SetPixelFormat( hGLDC, iPixelFormat, &pfd );
    hGLRC = wglCreateContext( hGLDC );
	wglMakeCurrent( hGLDC, hGLRC );

	CoCreateInstance(CLSID_CDeckLinkGLScreenPreviewHelper, NULL, CLSCTX_ALL, IID_IDeckLinkGLScreenPreviewHelper, (void**)&deckLinkScreenPreviewHelper);

	initializeGL ();

}

CDeckLinkPreview::~CDeckLinkPreview()
{
	wglDeleteContext( hGLRC );
	ReleaseDC(0, hGLDC );

	if(deckLinkScreenPreviewHelper != NULL)
	{
		deckLinkScreenPreviewHelper->Release();
		deckLinkScreenPreviewHelper = NULL;
	}

	DeleteCriticalSection(&mutex);
}

HRESULT CDeckLinkPreview::QueryInterface (REFIID iid, LPVOID *ppv)
{
    *ppv = NULL;
    return E_NOINTERFACE;
}

ULONG CDeckLinkPreview::AddRef ()
{
    LONG		oldValue;

    oldValue = refCount;
	InterlockedIncrement(&refCount);
    return (ULONG)(oldValue + 1);
}

ULONG CDeckLinkPreview::Release ()
{
	LONG		oldValue;

    oldValue = refCount;
	InterlockedDecrement(&refCount);
    if (oldValue == 1)
    {
        delete this;
    }

    return (ULONG)(oldValue - 1);
}

void CDeckLinkPreview::initializeGL ()
{
	EnterCriticalSection(&mutex);
	if (deckLinkScreenPreviewHelper != NULL)
    {
		deckLinkScreenPreviewHelper->InitializeGL();
		bRender = true;
    }
	LeaveCriticalSection(&mutex);
}

void CDeckLinkPreview::paintGL ()
{
	EnterCriticalSection(&mutex);

	if (bRender)
	{
		wglMakeCurrent( hGLDC, hGLRC );

		glLoadIdentity();

		glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		glClear(GL_COLOR_BUFFER_BIT);

		if (deckLinkScreenPreviewHelper != NULL)
		{
			deckLinkScreenPreviewHelper->PaintGL();
		}
	}

	LeaveCriticalSection(&mutex);
}

void CDeckLinkPreview::StopRender()
{
	EnterCriticalSection(&mutex);

	bRender = false;

	LeaveCriticalSection(&mutex);
}

HRESULT CDeckLinkPreview::DrawFrame (IDeckLinkVideoFrame* theFrame)
{
    if (deckLinkScreenPreviewHelper != NULL)
    {
        deckLinkScreenPreviewHelper->SetFrame(theFrame);
        paintGL();
    }
    return S_OK;
}
